<?php
session_start();
require '../../config.php';

if (!isset($_SESSION['admin']) || !isset($_SESSION['username'])) {
  header("Location: " . BASE_URL . "admin/login");
  exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  echo "Invalid application ID.";
  exit;
}

$app_id = (int) $_GET['id'];

$query = mysqli_query($conn, "SELECT * FROM employee_applications WHERE id = $app_id LIMIT 1");

if (!$query || mysqli_num_rows($query) === 0) {
  echo "Application not found.";
  exit;
}

$app = mysqli_fetch_assoc($query);
$full_name = trim(($app['title'] ? $app['title'] . ' ' : '') . $app['first_name'] . ' ' . $app['surname']);
?>

<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Application Details - <?= htmlspecialchars($full_name) ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <?php include __DIR__ . '/../partials/head.php'; ?>
</head>
<body class="d-flex flex-column min-vh-100">

<?php
  include __DIR__ . '/../partials/header.php';
  include __DIR__ . '/../partials/sidebar.php';
?>

<div class="body-wrapper">
  <div class="body-wrapper-inner container-fluid mt-4">
    <h2 class="mb-4">View / Update Application</h2>

    <div class="card p-4">
      <h4>Full Name: <?= htmlspecialchars($full_name) ?></h4>
      <p><strong>Email:</strong> <?= htmlspecialchars($app['email']) ?></p>
      <p><strong>Status:</strong> <?= htmlspecialchars($app['application_status']) ?></p>
      <!-- Add more fields and update form as needed -->
    </div>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>

</body>
</html>